//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// Used to pass data to the client thread
struct _ClientThreadInfo{
    Server *MyServer;
    int Client;
}; _ClientThreadInfo CTI;

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void SendMessageToAllClients(Server *pServer, int Client, char *SendData, int SendSize, bool SendToMe)
{
    int ClientLoop = 0;

    if(SendToMe == true)
        Client = -1;

    while(ClientLoop < MAXCLIENTS)
    {
        if(pServer->Connected[ClientLoop] && ClientLoop != Client)
        {
            while(!pServer->SetSendDataEx(ClientLoop, SendData, SendSize) && pServer->Connected[ClientLoop])
                Sleep(1);
        }

        ClientLoop++;
    }
}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

DWORD WINAPI Client_Thread(LPVOID pCTI)
{
    //--------------( Critical section, DO NOT MODIFIY! Begin )-------------
    _ClientThreadInfo *MyCTI = (_ClientThreadInfo *) pCTI;

	Server *pServer = MyCTI->MyServer;
	int Client      = MyCTI->Client;

    pServer->IsClientThreadActive[Client] = true;
    //--------------( Critical section, DO NOT MODIFIY! End )---------------

    char StatusTemp[255];

    FreeSingleClientInfo(Client);

    if(!CI[Client].WPIndexDB.DBConnect(gsSQLIndexDriver, gsSQLIndexServer, gsSQLIndexUserID, gsSQLIndexPassword, gsSQLIndexDatabase))
    {
        sprintf(StatusTemp, "(%d) Error connecting to the web portal index!", pServer->ClientID[Client]);
        WriteLog(StatusTemp);
        glErrorCount++;
        return ThreadWaitForDisconnect(pServer, Client);
    }

    SimpleServerSend(Client, "::Authentication");

    int AuthResult = AuthenticateClient(Client);
    if(AuthResult == AUTH_CMD_FAILED)
    {
        if(gbDebugMode)
        {
            sprintf(StatusTemp, "(%d) [DEBUG] Authentication Result: AUTH_CMD_FAILED.", pServer->ClientID[Client]);
            WriteLog(StatusTemp);
        }
        return ThreadWaitForDisconnect(pServer, Client);
    }
    else if(AuthResult == AUTH_CMD_SUCCESS)
    {
        if(gbDebugMode)
        {
            sprintf(StatusTemp, "(%d) [DEBUG] Authentication Result: AUTH_CMD_SUCCESS.", pServer->ClientID[Client]);
            WriteLog(StatusTemp);
        }
    }
    else if(AuthResult == AUTH_CMD_DISCONNECT)
    {
        if(gbDebugMode)
        {
            sprintf(StatusTemp, "(%d) [DEBUG] Authentication Result: AUTH_CMD_DISCONNECT.", pServer->ClientID[Client]);
            WriteLog(StatusTemp);
        }
        return ThreadWaitForDisconnect(pServer, Client);
    }
    else if(AuthResult == AUTH_CMD_UNKNOWN)
    {
        if(gbDebugMode)
        {
            sprintf(StatusTemp, "(%d) [DEBUG] Authentication Result: AUTH_CMD_UNKNOWN.", pServer->ClientID[Client]);
            WriteLog(StatusTemp);
        }
        return ThreadWaitForDisconnect(pServer, Client);
    }
    else{
        sprintf(StatusTemp, "(%d) Unknown authentication error.", pServer->ClientID[Client]);
        WriteLog(StatusTemp);
        return ThreadWaitForDisconnect(pServer, Client);
    }

    char ReceiveData[MaxReceiveSize + 1];
    int ReceiveSize = 0;

    while(pServer->Connected[Client])
    {
        if( pServer->GetReceiveData(Client, ReceiveData, &ReceiveSize) )
        {
            ReceiveData[ReceiveSize] = '\0';

            if(gbDebugMode)
            {
                sprintf(StatusTemp, "(%d) [DEBUG] Received %d bytes from client[%d].", pServer->ClientID[Client], ReceiveSize, Client);
                WriteLog(StatusTemp);
            }

            int CmdResult = ProcessCommand(Client, ReceiveData, ReceiveSize);
            if(CmdResult == COMMAND_RESULT_UNKNOWN)
            {
                if(gbDebugMode)
                {
                    sprintf(StatusTemp, "(%d) [DEBUG] Result: COMMAND_RESULT_UNKNOWN.", pServer->ClientID[Client]);
                    WriteLog(StatusTemp);
                }
                return ThreadWaitForDisconnect(pServer, Client);
            }
            else if(CmdResult == COMMAND_RESULT_DISCONNECT)
            {
                if(gbDebugMode)
                {
                    sprintf(StatusTemp, "(%d) [DEBUG] Result: COMMAND_RESULT_DISCONNECT.", pServer->ClientID[Client]);
                    WriteLog(StatusTemp);
                }
                return ThreadWaitForDisconnect(pServer, Client);
            }
            else if(CmdResult == COMMAND_RESULT_OK)
            {
                if(gbDebugMode)
                {
                    sprintf(StatusTemp, "(%d) [DEBUG] Result: COMMAND_RESULT_OK.", pServer->ClientID[Client]);
                    WriteLog(StatusTemp);
                }
            }
            else{
                sprintf(StatusTemp, "(%d) Result: Error occured.", pServer->ClientID[Client]);
                WriteLog(StatusTemp);
                return ThreadWaitForDisconnect(pServer, Client);
            }
        }
        else Sleep(glTCPLoopDelay);
    }

    return ThreadWaitForDisconnect(pServer, Client);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

